////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////                                                                        ////
////     01010101   010        010   0101010101   0101010101      0110      ////
////    01      01  01010    10101   01           01             01  10     ////
////   01        01 01 010  101 01   01           01             01  10     ////
////   01        01 01  010010  01   0101010101   01            01    10    ////
////    01      01  01    00    01   01           01    0101    01010110    ////
////     01    01   01          01   01           01      01   01      10   ////
////   0101    0101 01          01   0101010101   0101010101   01      10   ////
////                                                                        ////
////                                                                        ////
////   0101010101   010     01   0101010101   01   010     01   0101010101  ////
////   01           010     01   01           01   010     01   01          ////
////   01           01 01   01   01           01   01 01   01   01          ////
////   0101010101   01  01  01   01           01   01  01  01   0101010101  ////
////   01           01   01 01   01    0101   01   01   01 01   01          ////
////   01           01    0101   01      01   01   01    0101   01          ////
////   0101010101   01     001   0101010101   01   01     011   0101010101  ////
////                                                                        ////
////       : 1.1                                                      ////
////         : 21.08.07                                                 ////
////   e: http://www.isada.mirgames.ru/omega.php                   ////
////                                                                        ////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////                                                                        ////
////  : Andru 'aka'                                         ////
////  Mail: dr.andru@gmail.com                                              ////
////  Site: http://isada.mirgames.ru                                        ////
////                                                                        ////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////                                                                        ////
////                                    :             ////
////                                                                        ////
////                ////
////      .      .             ////
////                                                             ()2007    ////
////                                                                        ////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
unit OMEGA;

//Delphi 3
{$IFDEF VER100}
  {$DEFINE DELPHI}
{$ENDIF}
//Delphi 4
{$IFDEF VER120}
  {$DEFINE DELPHI}
{$ENDIF}
//Delphi 5
{$IFDEF VER130}
  {$DEFINE DELPHI}
{$ENDIF}
//Delphi 6
{$IFDEF VER140}
  {$DEFINE DELPHI}
{$ENDIF}
//Delphi 7
{$IFDEF VER150}
  {$DEFINE DELPHI}
{$ENDIF}
//Delphi 2005
{$IFDEF VER170}
  {$DEFINE DELPHI}
{$ENDIF}
//Delphi 2006
{$IFDEF VER180}
  {$DEFINE DELPHI}
{$ENDIF}

{$IFNDEF DELPHI}
  {$MODE DELPHI}
{$ENDIF}

interface

type
  DWORD = LongWord;

// G L O B A L  T Y P E S
type
  TMemory = record
    Ptr  : Pointer;
    Size : DWORD;
end;
PMemory = ^TMemory;

//----------------------------------------------------------------------------//
//-----------------------------  E N G I N E  --------------------------------//
//----------------------------------------------------------------------------//

var
  LibOmega : HMODULE;

procedure LoadOMEGA( FileName : String );
procedure FreeOMEGA;

var
OE_Test : function( zBits : Byte = 16; stencilBits : Byte = 0 ) : Boolean; stdcall;

// S T A R T
OE_Init  : procedure( zBits : Byte = 16; stencilBits : Byte = 0 ); stdcall;
OE_Init2 : procedure( HWND : DWORD; zBits : Byte = 16; stencilBits : Byte = 0 ); stdcall;
OE_Quit  : procedure; stdcall;

// M A I N
const
  SYS_DRAW            = 0;
  SYS_INIT            = 1;
  SYS_QUIT            = 2;
  SYS_LOAD            = 3;
  SYS_WNDPROC_BEFORE  = 4;
  SYS_WNDPROC_AFTER   = 5;
  SYS_CONSOLE_MESSAGE = 6;

var
OE_RegProcedure    : procedure( PType : Byte; PAddress : Pointer ); stdcall;
OE_UnRegProcedure  : procedure( PType : Byte ); stdcall;

// T I M E R S
type
  TOTimer = record
    Active    : Boolean;
    Interval  : DWORD;
    LastTime  : Double;
    Precision : Integer;
    OnTimer   : Procedure;
    Reserved  : DWORD;
end;
POTimer = ^TOTimer;

var
Timer_Create  : function( OnTimer : Pointer; Interval : Integer = 1000; Precision : Integer = 1 ) : POTimer; stdcall;
Timer_Free    : procedure( var Timer : POTimer ); stdcall;
Timer_FreeAll : procedure; stdcall;

// O P T I O N S
//FLAGS
const
  FLAG_CLEAR_COLOR_BUFFER = $000001;
  FLAG_CROP_UNVISIBLE_OBJ = $000002;
  FLAG_RESOLUTION_CORRECT = $000004;
  FLAG_SHOW_WARNINGS      = $000008;
  FLAG_SHOW_ERRORS        = $000010;
  FLAG_PAUSE              = $000020;
  FLAG_AUTO_PAUSE         = $000040;

var
OE_Enable  : procedure( What : Integer ); stdcall;
OE_Disable : procedure( What : Integer ); stdcall;

//WINDOW
OE_SetWndOnTop    : procedure( Enable : Boolean ); stdcall;
OE_SetWndPosition : procedure( X, Y : Integer ); stdcall;
OE_SetWndName     : procedure( NewName : PChar ); stdcall;
OE_ResizeWindow   : procedure( Width, Height : Integer ); stdcall;

OE_ShowCursor : procedure( Show : Boolean ); stdcall;

const
  REFRESH_MAXIMUM = 0;
  REFRESH_DEFAULT = 1;
var
//SCREEN
OE_SetScreenOptions        : procedure( Width, Height, BPP, Refresh : Integer; FullScreen, WaitVSync : Boolean ); stdcall;
OE_ChangeScreenOptions     : procedure( Width, Height, BPP, Refresh : Integer; FullScreen, WaitVSync : Boolean ); stdcall;
OE_SetResolutionDependence : procedure( NormalResX, NormalResY : Integer ); stdcall;
OE_SetVSync                : procedure( WaitVSync : Boolean ); stdcall;

//GET
type
  TOptions = record
    app_FullScreen : Boolean;
    wnd_X          : Integer;
    wnd_Y          : Integer;
    wnd_Width      : Integer;
    wnd_Height     : Integer;
    scr_Width      : Integer;
    scr_Height     : Integer;
    scr_BPP        : Integer;
    scr_Refresh    : Byte;
    scr_VSync      : Boolean;
    Reserved       : Boolean;
end;
POptions = ^TOptions;

var
OE_GetOptions : function : POptions; stdcall;

// A D D I T I O N A L
OE_SetAdvancedOptions : procedure( UseLog      : Boolean;
                                   AppCanClose : Boolean = TRUE;
                                   HaltOnExit  : Boolean = FALSE ); stdcall;

OE_GetFPS : function : Integer; stdcall;

//----------------------------------------------------------------------------//
//----------------------------------  I N I  ---------------------------------//
//----------------------------------------------------------------------------//

INI_LoadFromFile   : procedure( FileName : PChar ); stdcall;
INI_LoadFromMemory : procedure( Memory : PMemory ); stdcall;
INI_SaveToFile     : procedure( FileName : PChar ); stdcall;
INI_Add            : procedure( Section, Key : PChar ); stdcall;
INI_ReadKeyStr     : function( Section, Key : PChar ) : PChar; stdcall;
INI_ReadKeyInt     : function( Section, Key : PChar ) : Integer; stdcall;
INI_WriteKeyStr    : function( Section, Key, Value : PChar ) : Boolean; stdcall;
INI_WriteKeyInt    : function( Section, Key : PChar; Value : Integer ) : Boolean; stdcall;

//----------------------------------------------------------------------------//
//-----------------------------  H T M L  L O G  -----------------------------//
//----------------------------------------------------------------------------//

const
  LOGT_ERROR   = 0;
  LOGT_WARNING = 1;
  LOGT_APP     = 2;
  LOGT_CONSOLE = 3;

var
LOG_SetOptions : procedure(
                            clrBODY    : PChar {= '808080'};
                            clrTIME    : PChar {= 'yellowgreen'};
                            clrENGINE  : PChar {= '00ff00'};
                            clrAPP     : PChar {= 'blue'};
                            clrCONSOLE : PChar {= 'blue'};
                            clrMESS    : PChar {= 'black'};
                            clrWARNING : PChar {= 'orange'};
                            clrERROR   : PChar {= 'red'};
                            sTIME      : Byte  = 2;
                            sENGINE    : Byte  = 4;
                            sAPP       : Byte  = 4;
                            sCONSOLE   : Byte  = 4;
                            sMESS      : Byte  = 3;
                            sWARNING   : Byte  = 4;
                            sERROR     : Byte  = 4 ); stdcall;

LOG_Init       : procedure( FileName : PChar; Create : Boolean ); stdcall;
LOG_AddMessage : procedure( MessageType : Byte; Text : PChar ); stdcall;
LOG_AddLine    : procedure( Size  : Integer; Color : PChar ); stdcall;

//----------------------------------------------------------------------------//
//------------------------------  I N P U T  ---------------------------------//
//----------------------------------------------------------------------------//

// K E Y B O A R D
const
  K_LAYOUT_ENG = '00000409';
  K_LAYOUT_RUS = '00000419';

  K_BACKSPACE  = 8;
  K_TAB        = 9;
  K_ENTER      = 13;
  K_SHIFT      = 16;
  K_CTRL       = 17;
  K_ALT        = 18;
  K_ESCAPE     = 27;
  K_SPACE      = 32;

  K_PAGEUP     = 33;
  K_PAGEDOWN   = 34;
  K_END        = 35;
  K_HOME       = 36;
  K_SNAPSHOT   = 44;
  K_INSERT     = 45;
  K_DELETE     = 46;

  K_LEFT       = 37;
  K_UP         = 38;
  K_RIGHT      = 39;
  K_DOWN       = 40;

  K_0          = 48;
  K_1          = 49;
  K_2          = 50;
  K_3          = 51;
  K_4          = 52;
  K_5          = 53;
  K_6          = 54;
  K_7          = 55;
  K_8          = 56;
  K_9          = 57;

  K_NUMPAD0    = 96;
  K_NUMPAD1    = 97;
  K_NUMPAD2    = 98;
  K_NUMPAD3    = 99;
  K_NUMPAD4    = 100;
  K_NUMPAD5    = 101;
  K_NUMPAD6    = 102;
  K_NUMPAD7    = 103;
  K_NUMPAD8    = 104;
  K_NUMPAD9    = 105;

  K_MULTIPLY   = 106;
  K_ADD        = 107;
  K_SEPARATOR  = 108;
  K_SUBTRACT   = 109;
  K_DECIMAL    = 110;
  K_DIVIDE     = 111;

  K_A          = 65;
  K_B          = 66;
  K_C          = 67;
  K_D          = 68;
  K_E          = 69;
  K_F          = 70;
  K_G          = 71;
  K_H          = 72;
  K_I          = 73;
  K_J          = 74;
  K_K          = 75;
  K_L          = 76;
  K_M          = 77;
  K_N          = 78;
  K_O          = 79;
  K_P          = 80;
  K_Q          = 81;
  K_R          = 82;
  K_S          = 83;
  K_T          = 84;
  K_U          = 85;
  K_V          = 86;
  K_W          = 87;
  K_X          = 88;
  K_Y          = 89;
  K_Z          = 90;

  K_F1         = 112;
  K_F2         = 113;
  K_F3         = 114;
  K_F4         = 115;
  K_F5         = 116;
  K_F6         = 117;
  K_F7         = 118;
  K_F8         = 119;
  K_F9         = 120;
  K_F10        = 121;
  K_F11        = 122;
  K_F12        = 123;

var
Key_LoadLayout    : procedure( Layout : PChar ); stdcall;
KeyEx_Down        : function( KeyCode : Byte ) : Boolean; stdcall;
Key_Down          : function( KeyCode : Byte ) : Boolean; stdcall;
Key_Press         : function( KeyCode : Byte ) : Boolean; stdcall;
Key_LastDown      : function : Byte; stdcall;
Key_LastPress     : function : Byte; stdcall;
Key_BeginReadText : procedure( StartText : PChar ); stdcall;
Key_EndReadText   : function : PChar; stdcall;
Key_MaxReadText   : procedure( Count : Integer ); stdcall;

// M O U S E
const
  M_RBUTTON = 0;
  M_LBUTTON = 1;
  M_MBUTTON = 2;

var
MouseEx_X       : function : Integer; stdcall;
MouseEx_Y       : function : Integer; stdcall;
MouseEx_Down    : function( Button : Byte ) : Boolean; stdcall;
Mouse_X         : function : Integer; stdcall;
Mouse_Y         : function : Integer; stdcall;
Mouse_Move      : function : Boolean; stdcall;
Mouse_Lock      : procedure; stdcall;
Mouse_DeltaX    : function : Integer; stdcall;
Mouse_DeltaY    : function : Integer; stdcall;
Mouse_Down      : function( Button : Byte ) : Boolean; stdcall;
Mouse_Press     : function( Button : Byte ) : Boolean; stdcall;
Mouse_Click     : function( Button : Byte ) : Boolean; stdcall;
Mouse_DblClick  : function( Button : Byte ) : Boolean; stdcall;
Mouse_WheelUp   : function : Boolean; stdcall;
Mouse_WheelDown : function : Boolean; stdcall;

// J O Y P A D
const
  JOY_0      = $000000;

  JOY_XLEFT  = $000001;
  JOY_XRIGHT = $000002;
  JOY_YUP    = $000003;
  JOY_YDOWN  = $000004;

  JOY_BTN01  = $00000001;
  JOY_BTN02  = $00000002;
  JOY_BTN03  = $00000004;
  JOY_BTN04  = $00000008;
  JOY_BTN05  = $00000010;
  JOY_BTN06  = $00000020;
  JOY_BTN07  = $00000040;
  JOY_BTN08  = $00000080;
  JOY_BTN09  = $00000100;
  JOY_BTN10  = $00000200;
  JOY_BTN11  = $00000400;
  JOY_BTN12  = $00000800;
  JOY_BTN13  = $00001000;
  JOY_BTN14  = $00002000;
  JOY_BTN15  = $00004000;
  JOY_BTN16  = $00008000;
  JOY_BTN17  = $00010000;
  JOY_BTN18  = $00020000;
  JOY_BTN19  = $00040000;
  JOY_BTN20  = $00080000;
  JOY_BTN21  = $00100000;
  JOY_BTN22  = $00200000;
  JOY_BTN23  = $00400000;
  JOY_BTN24  = $00800000;
  JOY_BTN25  = $01000000;
  JOY_BTN26  = $02000000;
  JOY_BTN27  = $04000000;
  JOY_BTN28  = $08000000;
  JOY_BTN29  = $10000000;
  JOY_BTN30  = $20000000;
  JOY_BTN31  = $40000000;
  JOY_BTN32  = $80000000;

var
Joy_Down   : function( Joy, Button : Integer ) : Boolean; stdcall;
Joy_Press  : function( Joy, Button : Integer ) : Boolean; stdcall;
Joy_AxePos : function( Joy, AxePos : Integer ) : Boolean; stdcall;

//----------------------------------------------------------------------------//
//----------------------------  T E X T U R E S  -----------------------------//
//----------------------------------------------------------------------------//

type
  TTexture = record
    ID            : Cardinal;
    Width, Height : Integer;
    U, V          : Single;
    Flags         : Integer;
    FramesX       : WORD;
    FramesY       : WORD;
    Reserved      : DWORD;
end;
PTexture = ^TTexture;

const
  TEXTYPE_BJGWI = $000000; // BMP, JPG, GIF, WMF, ICO
  TEXTYPE_TGA   = $000001; // TGA

const
  TEX_MIPMAP            = $000001;
  TEX_CLAMP             = $000002;
  TEX_REPEAT            = $001000;
  TEX_COMPRESS          = $000004;

  // Special
  TEX_OMEGA_TO_2X2      = $000008;

  // Effects
  TEX_GRAYSCALE         = $000010;
  TEX_INVERT            = $000020;
  TEX_USEMASK           = $000040;

  // Filtering
  TEX_FILTER_NEAREST    = $000080;
  TEX_FILTER_LINEAR     = $000100;
  TEX_FILTER_BILINEAR   = $000200;
  TEX_FILTER_TRILINEAR  = $000400;
  TEX_FILTER_ANISOTROPY = $000800;

  // Quality
  TEX_QUALITY_LOW 	    = $400000;
	TEX_QUALITY_MEDIUM    = $800000;

  TEX_DEFAULT_2D        = TEX_OMEGA_TO_2X2 or TEX_FILTER_LINEAR or TEX_CLAMP;
  TEX_DEFAULT_3D        = TEX_MIPMAP or TEX_FILTER_TRILINEAR or TEX_CLAMP;

var
Tex_Filter             : procedure( var Texture : PTexture; Flags : Integer ); stdcall;
Tex_SetAnisotropyLevel : procedure( Level : Integer ); stdcall;
Tex_CreateZero         : function( Width, Height, Flags : Integer ) : PTexture; stdcall;
Tex_LoadFromFile       : function( FileName : PChar; TransparentColor, Flags : Integer ) : PTexture; stdcall;
Tex_LoadFromMemory     : function( Memory : PMemory; FormatType, TransparentColor, Flags : Integer ) : PTexture; stdcall;
Tex_Free               : procedure( var Texture : PTexture ); stdcall;
Tex_FreeAll            : procedure; stdcall;
Tex_LoadMaskFromFile   : procedure( FileName : PChar ); stdcall;
Tex_LoadMaskFromMemory : procedure( Memory : PMemory ); stdcall;
Tex_FreeMask           : procedure; stdcall;
Tex_SetFramesSize      : procedure( Texture : PTexture; FrameWidth, FrameHeight : Word ); stdcall;

//----------------------------------------------------------------------------//
//-----------------------  R E N D E R  T O  T E X T U R E  ------------------//
//----------------------------------------------------------------------------//
Tex_BeginRenderIn : procedure( Texture  : PTexture;
                               SaveOld  : Boolean = FALSE;
                               RealSize : Boolean = FALSE;
                               Clear    : Boolean = TRUE ); stdcall;
Tex_EndRenderIn   : procedure; stdcall;

//----------------------------------------------------------------------------//
//----------------------------  C A M E R A  2 D  ----------------------------//
//----------------------------------------------------------------------------//

type
  TCamera2D = record
    X, Y     : Single;
    Active   : Boolean;
    Reserved : DWORD;
end;
PCamera2D = ^TCamera2D;

var
Cam2D_Create  : function : PCamera2D; stdcall;
Cam2D_Free    : procedure( var YourCamera : PCamera2D ); stdcall;
Cam2D_FreeAll : procedure; stdcall;
Cam2D_Set     : procedure( YourCamera : PCamera2D ); stdcall;

//----------------------------------------------------------------------------//
//----------------------------------  F X  -----------------------------------//
//----------------------------------------------------------------------------//

const
  FX_BLEND    = $000001;
  FX_FLIPX    = $000002;
  FX_FLIPY    = $000004;
  FX_COLORMIX = $000008;
  FX_SCALE    = $000010;
  FX_VCHANGE  = $000020;
  FX_VCA      = $000040;

  FX_DEFAULT  = FX_BLEND;

  FX_BLEND_NORMAL = $000000;
  FX_BLEND_ADD    = $000001;
  FX_BLEND_MULT   = $000002;
  FX_BLEND_BLACK  = $000003;
  FX_BLEND_WHITE  = $000004;
  FX_BLEND_MASK   = $000005;

var
FX_SetColorMix  : procedure( Color : Integer ); stdcall;
FX_SetBlendMode : procedure( Mode : Integer ); stdcall;
FX_SetScale     : procedure( ScaleX, ScaleY : Single ); stdcall;
FX_SetVertexes  : procedure( X1, Y1, X2, Y2, X3, Y3, X4, Y4 : Integer ); stdcall;
FX_SetVCA       : procedure( C1, C2, C3, C4 : Integer; A1, A2, A3, A4 : Byte ); stdcall;

// B L U R
FX_Blur_SetTex    : procedure( TexToRender : PTexture ); stdcall;
FX_Blur_SetParams : procedure( Count, MoveX, MoveY : Integer ); stdcall;
FX_Blur_Calc      : procedure( RenderProc : Pointer; Delta : Single; Alpha : Byte; BlendMode : Integer = FX_BLEND_NORMAL ); stdcall;
FX_Blur_Draw      : procedure( Color : Integer; Alpha : Byte ); stdcall;

// "R A D I A L"  B L U R
FX_RadBlur_SetTex    : procedure( TexToRender : PTexture ); stdcall;
FX_RadBlur_SetParams : procedure( Count, MoveX, MoveY : Integer ); stdcall;
FX_RadBlur_Calc      : procedure( RenderProc : Pointer; Alpha : Byte; BlendMode : Integer = FX_BLEND_NORMAL ); stdcall;
FX_RadBlur_Draw      : procedure( Color : Integer; Alpha : Byte ); stdcall;

//----------------------------------------------------------------------------//
//------------------------------  T E X T  2 D  ------------------------------//
//----------------------------------------------------------------------------//

type
  TSymbol = record
    X, Y  : WORD;
    Width : Byte;
end;

type
  TFont2D = record
    Height   : Byte;
    Sizes    : array[ 0..255 ] of TSymbol;
    Texture  : PTexture;
    Reserved : DWORD;
end;
PFont2D = ^TFont2D;

var
Text_LoadFontFromFile   : function( FontTexture      : PChar;
                                    FontInfo         : PChar;
                                    TransparentColor : Integer = $000000;
                                    TexFlags         : Integer = TEX_DEFAULT_2D ) : PFont2D; stdcall;
Text_LoadFontFromMemory : function( FontTexture      : PMemory;
                                    FontTexType      : Integer;
                                    FontInfo         : PMemory;
                                    TransparentColor : Integer = $000000;
                                    TexFlags         : Integer = TEX_DEFAULT_2D ) : PFont2D; stdcall;
Text_FreeFont          : procedure( var Font : PFont2D ); stdcall;
Text_FreeFontAll       : procedure; stdcall;
Text_Draw              : procedure( Font  : PFont2D;
                                    X, Y  : Single;
                                    Text  : PChar;
                                    Scale : Single  = 1.0;
                                    Step  : Single  = 0;
                                    Alpha : Byte    = 255;
                                    Color : Integer = $FFFFFF ); stdcall;
Text_GetWidth          : function( Font  : PFont2D;
                                   Text  : PChar;
                                   Scale : Single = 1.0;
                                   Step  : Single = 0 ) : Integer; stdcall;

// DEBUG FONT's
Text_InitDebugFont : function( FontName : PChar; Size : Integer; ANSI : Boolean = FALSE ) : DWORD; stdcall;
Text_FreeDebugFont : procedure( FontID : DWORD ); stdcall;
Text_DrawDebugText : procedure( FontID : DWORD; X, Y : Single; Text : PChar; Color : Integer = $FFFFFF ); stdcall;

//----------------------------------------------------------------------------//
//------------------------------  C O N S O L E  -----------------------------//
//----------------------------------------------------------------------------//

Console_Active       : procedure( Enable : Boolean ); stdcall;
Console_SetOptions   : procedure( Font      : PFont2D;
                                  Texture   : PTexture;
                                  Color     : Integer = 0;
                                  Alpha     : Byte    = 155;
                                  FontColor : Integer = $FFFFFF;
                                  FontAlpha : Byte    = 255 ); stdcall;
Console_ToLog        : procedure( Connect : Boolean ); stdcall;
Console_Draw         : procedure; stdcall;
Console_RegCommand   : procedure( Command : PChar; Execute : Pointer ); stdcall;
Console_RegVariable  : procedure( VarName : PChar; Variable : PInteger ); stdcall;
Console_RegProcedure : procedure( ProcName : PChar; ProcPtr : Pointer ); stdcall;
Console_AddString    : procedure( Str : PChar ); stdcall;

//----------------------------------------------------------------------------//
//-----------------------  P R I M I T I V E S  2 D  -------------------------//
//----------------------------------------------------------------------------//

const
  PR_FILL    = $000001;
  PR_SMOOTH  = $000002;

  PR_DEFAULT = 0;

type
  oePoint = record
    X, Y : Single;
end;
oePPoint = ^oePoint;

type
  oePointCA = record
    X, Y  : Single;
    Color : Integer;
    Alpha : Byte;
end;
oePPointCA = ^oePointCA;

type
  oeLine = record
    x0, y0 : Single;
    x1, y1 : Single;
end;
oePLine = ^oeLine;

type
  oeRect = record
    X      : Single;
    Y      : Single;
    Width  : Single;
    Height : Single;
end;
oePRect = ^oeRect;

type
  oeTriangle = record
    X1, Y1 : Single;
    X2, Y2 : Single;
    X3, Y3 : Single;
end;
oePTriangle = ^oeTriangle;

type
  oeCircle = record
    cX, cY : Single;
    Radius : Single;
end;
oePCircle = ^oeCircle;

var
Pr2D_PixelSize : procedure( Size : Integer ); stdcall;
Pr2D_LineWidth : procedure( Width : Integer ); stdcall;
Pr2D_Pixel     : procedure( X, Y : Single; Color : Integer; Alpha : Byte = 255 ); stdcall;
Pr2D_Line      : procedure( X1, Y1, X2, Y2 : Single; Color : Integer; Alpha : Byte = 255; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_TLine     : procedure( Line : oePLine; Color : Integer; Alpha : Byte = 255; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_Rect      : procedure( X, Y, Width, Height : Single; Color : Integer; Alpha : Byte = 255; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_TRect     : procedure( Rectangle : oePRect; Color : Integer; Alpha : Byte = 255; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_Triangle  : procedure( X1, Y1, X2, Y2, X3, Y3 : Single; Color : Integer; Alpha : Byte = 255; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_TTriangle : procedure( Triangle : oePTriangle; Color : Integer; Alpha : Byte = 255; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_Circle    : procedure( cX, cY, Radius : Single; Color : Integer; Alpha : Byte = 255; Quality : Integer = 32; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_TCircle   : procedure( Circle : oePCircle; Color : Integer; Alpha : Byte = 255; Quality : Integer = 32; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_Ellipse   : procedure( cX, cY, xRadius, yRadius : Single; Color : Integer; Alpha : Byte = 255; Quality : Integer = 32; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_Polygon   : procedure( Points : array of oePoint; PCount, Color : Integer; Alpha : Byte = 255; Flags : Integer = PR_DEFAULT ); stdcall;
Pr2D_PolygonCA : procedure( Points : array of oePointCA; PCount : Integer; Flags : Integer = PR_DEFAULT ); stdcall;

//----------------------------------------------------------------------------//
//----------------------------  S P R I T E S  -------------------------------//
//----------------------------------------------------------------------------//

// S T A T I C
SSprite_Draw : procedure( Tex : PTexture; X, Y, Width, Height : Single; Alpha : Byte = 255; Angle : Single = 0; Flags : Integer = FX_DEFAULT ); stdcall;

// A N I M A T E D
ASprite_Draw : procedure( Tex : PTexture; X, Y, Width, Height : Single; FrameNow : Integer; Alpha : Byte = 255; Angle : Single = 0; Flags : Integer = FX_DEFAULT ); stdcall;

// C U T
CSprite_Draw : procedure( Tex : PTexture; X, Y, Width, Height : Single; CutRect : oePRect; Alpha : Byte = 255; Angle : Single = 0; Flags : Integer = FX_DEFAULT ); stdcall;

//----------------------------------------------------------------------------//
//------------------------------  T I L E S  ---------------------------------//
//----------------------------------------------------------------------------//

// S T A T I C
STile_Draw : procedure( Tex : PTexture; X, Y, Width, Height : Single; TilesX, TilesY : Integer; Alpha : Byte = 255; Flags : Integer = FX_DEFAULT ); stdcall;

// A N I M A T E D
ATile_Draw : procedure( Tex : PTexture; X, Y, Width, Height : Single; TilesX, TilesY, FrameNow : Integer; Alpha : Byte = 255; Flags : Integer = FX_DEFAULT ); stdcall;

//----------------------------------------------------------------------------//
//-----------------------------  S C I S S O R  ------------------------------//
//----------------------------------------------------------------------------//

Scissor_Begin : procedure( X, Y, Width, Height : Integer ); stdcall;
Scissor_End   : procedure; stdcall;

//----------------------------------------------------------------------------//
//------------------------------  S O U N D  ---------------------------------//
//----------------------------------------------------------------------------//

type PSound = Pointer;

var
Snd_Init            : function : Boolean; stdcall;
Snd_Active          : procedure( Active : Boolean ); stdcall;
Snd_LoadFromFile    : function( FileName : PChar; BufferCount : Integer ) : PSound; stdcall;
Snd_LoadFromMemory  : function( Memory : PMemory; BufferCount : Integer ) : PSound; stdcall;
Snd_Free            : procedure( var Sound : PSound ); stdcall;
Snd_FreeAll         : procedure; stdcall;
Snd_SetBuffersCount : procedure( Sound : PSound; Count : Integer ); stdcall;
Snd_Play            : function( Sound     : PSound;
                                Pan       : Integer = 0;
                                Volume    : Integer = 0;
                                Frequency : Integer = 0;
                                Loop      : Boolean = FALSE ) : Integer; stdcall;
Snd_PlayID          : procedure( Sound      : PSound;
                                 ID         : Integer;
                                 Pan        : Integer = 0;
                                 Volume     : Integer = 0;
                                 Frequency  : Integer = 0;
                                 Loop       : Boolean = FALSE ); stdcall;
Snd_Stop            : procedure( Sound : PSound ); stdcall;
Snd_StopID          : procedure( Sound : PSound; ID : Integer ); stdcall;
Snd_StopAll         : procedure; stdcall;
Snd_ChangeParam     : procedure( Sound : PSound; ID, Pan, Volume, Frequency : Integer ); stdcall;

//     0..100
function VOLUME( Value : Byte ) : Integer; stdcall;

//----------------------------------------------------------------------------//
//-------------------------------  M E D I A  --------------------------------//
//----------------------------------------------------------------------------//

var
Media_Play          : procedure( FileName : PChar; Loop : Boolean ); stdcall;
Media_Replay        : procedure; stdcall;
Media_Pause         : procedure; stdcall;
Media_Resume        : procedure; stdcall;
Media_Stop          : procedure; stdcall;
Media_SetVolume     : procedure( Volume : Integer ); stdcall;
Media_GetLength     : function : Double; stdcall;
Media_SetPosition   : procedure( Position : Double ); stdcall;
Media_GetPosition   : function : Double; stdcall;
Media_SetWindowRect : procedure( X, Y, Width, Height : Integer ); stdcall;

//----------------------------------------------------------------------------//
//---------------------------  C O L L I S I O N  ----------------------------//
//----------------------------------------------------------------------------//

type
  TPoint2D = oePoint;
  PPoint2D = oePPoint;

type
  TLine2D = oeLine;
  PLine2D = oePLine;

type
  TPolyLine2D = record
    Count  : DWORD;
    cX, cY : Single;
    Points : array of TPoint2D;
end;
PPolyLine2D = ^TPolyLine2D;

type
  TAABB2D = oeRect;
  PAABB2D = oePRect;

type
  TOBB2D = record
    X, Y   : Single;
    Width  : Single;
    Height : Single;
    Angle  : Single;
end;
POBB2D = ^TOBB2D;

type
  TCircle2D = oeCircle;
  PCircle2D = oePCircle;

var
// P O I N T ' s
Col_PointInAABB     : function( X, Y : Single; AABB : PAABB2D ) : Boolean; stdcall;
Col_PointInCircle   : function( X, Y : Single; Circ : PCircle2D ) : Boolean; stdcall;
Col_PointInPolyLine : function( X, Y : Single; PL : PPolyLine2D ) : Boolean; stdcall;

// L I N E ' s
Col_Line           : function( A, B : PLine2D ) : Boolean; stdcall;
Col_LineVsAABB     : function( A : PLine2D; AABB : PAABB2D ) : Boolean; stdcall;
Col_LineVsCircle   : function( L : PLine2D; Circ : PCircle2D ) : Boolean; stdcall;
Col_LineVsCircleXY : function( L : PLine2D; Circ : PCircle2D; Precision : Integer ) : Boolean; stdcall;
Col_LineVsPolyLine : function( A : PLine2D; B : PPolyLine2D ) : Boolean; stdcall;

// P O L Y L I N E ' s
Col_PolyLine           : function( A, B : PPolyLine2D ) : Boolean; stdcall;
Col_PolyLineVsAABB     : function( A : PPolyLine2D; AABB : PAABB2D ) : Boolean; stdcall;
Col_PolyLineVsCircle   : function( A : PPolyLine2D; Circ : PCircle2D ) : Boolean; stdcall;
Col_PolyLineVsCircleXY : function( A : PPolyLine2D; Circ : PCircle2D; Precision : Integer ) : Boolean; stdcall;

// A A B B ' s
Col_AABB         : function( AABB1, AABB2 : PAABB2D ) : Boolean; stdcall;
Col_AABBInAABB   : function( AABB1, AABB2 : PAABB2D ) : Boolean; stdcall;
Col_AABBInCircle : function( AABB : PAABB2D; Circ : PCircle2D ) : Boolean; stdcall;
Col_AABBVsCircle : function( AABB : PAABB2D; Circ : PCircle2D ) : Boolean; stdcall;

// C I R C L E ' s
Col_Circle         : function( Circ1, Circ2 : PCircle2D ) : Boolean; stdcall;
Col_CircleInCircle : function( Circ1, Circ2 : PCircle2D ) : Boolean; stdcall;
Col_CircleInAABB   : function( Circ : PCircle2D; AABB : PAABB2D ) : Boolean; stdcall;

// E X T E N D E D  F U N C T I O N S
// G E T ' s
ColEx_LastX : function : Single; stdcall;
ColEx_LastY : function : Single; stdcall;

ColEx_LastLineA : function : Integer; stdcall;
ColEx_LastLineB : function : Integer; stdcall;

// T R A N S F O R M A T I O N ' s
ColEx_PolyRotate : procedure( A, B: PPolyLine2D; Angle : Single ); stdcall;
ColEx_PolyScale  : procedure( A : PPolyLine2D; ScaleX, ScaleY : Single ); stdcall;
ColEx_PolyMove   : procedure( A, B : PPolyLine2D; X, Y : Single ); stdcall;
ColEx_PolyCenter : procedure( A : PPolyLine2D ); stdcall;
ColEx_PolyRect   : procedure( A : PPolyLine2D; Rect : PAABB2D ); stdcall;

// L I N E ' s
ColEx_CalcLineCross : procedure( A, B : PLine2D ); stdcall;

//----------------------------------------------------------------------------//
//----------------------------  F A S T  M A T H  ----------------------------//
//----------------------------------------------------------------------------//

M_Cos       : function( Angle : Integer ) : Single; stdcall;
M_Sin       : function( Angle : Integer ) : Single; stdcall;
M_CosF      : function( Angle : Integer ) : Single; stdcall;
M_SinF      : function( Angle : Integer ) : Single; stdcall;
M_Round     : function( Value : Single ) : Integer; stdcall;
M_Trunc     : function( Value : Single ) : Integer; stdcall;
M_Distance  : function( X1, Y1, X2, Y2 : Single ) : Single; stdcall;
M_FindAngle : function( X1, Y1, X2, Y2 : Integer ) : Integer; stdcall;

//----------------------------------------------------------------------------//
//-------------------------------  M E M O R Y  ------------------------------//
//----------------------------------------------------------------------------//

Mem_Get     : procedure( var p : Pointer; Size : Integer ); stdcall;
Mem_Realloc : procedure( var p : Pointer; Size : Integer ); stdcall;
Mem_Free    : procedure( var p : Pointer ); stdcall;

//----------------------------------------------------------------------------//
//--------------------------------  U T I L S  -------------------------------//
//----------------------------------------------------------------------------//

// H A R D W A R E
U_GetCPUName       : function : PChar; stdcall;
U_GetTotalRAM      : function : Integer; stdcall;
U_Is3DAccelerator  : function : Boolean; stdcall;
U_GetMaxTexSize    : function : Integer; stdcall;
U_GetMaxAnisotropy : function : Integer; stdcall;

// A D D I T I O N A L  F O R  E N G I N E
U_SnapShot : procedure( Path, FileName : PChar ); stdcall;

// C O N V E R T
U_IntToStr   : function( Num : Integer ) : PChar; stdcall;
U_StrToInt   : function( Str : PChar ) : Integer; stdcall;
U_FloatToStr : function( Num : Single ) : PChar; stdcall;
U_GetTime    : function : Double; stdcall;

const
  gENGINE_HWND    = $000000; //PDWORD
  gENGINE_DC      = $000001; //PDWORD
  gENGINE_GLRC    = $000002; //PDWORD
  gENGINE_LOG     = $000008; //PBoolean  
  gENGINE_FLAGS   = $000010; //PInteger
  gENGINE_APPDIR  = $000015; //PChar

  gOGL_WIDTH      = $000003; //PInteger
  gOGL_HEIGHT     = $000004; //PInteger
	gOGL_EXTENSIONS = $000009; //PChar

  gDX_DEVICE     = $000012; //PIDirect3DDevice8;
  gDX_PARAMS     = $000013;
  gDX_TEXMANAGER = $000014;

  gCURRENT_CAM2D  = $000005; //^PCamera2D

  gCONSOLE_ACTIVE = $000011; //PBoolean

  gSCREEN_SCALEX  = $000006; //PSingle
  gSCREEN_SCALEY  = $000007; //PSingle

var
P_GetParams : function( What : Integer ) : Pointer; stdcall;

Tex_PostProcess : function( var pData        : Pointer;
                            var Info         : TTexture;
                            TransparentColor : Integer ) : PTexture; stdcall;

//----------------------------------------------------------------------------//
                                 IMPLEMENTATION
//----------------------------------------------------------------------------//
function MessageBoxA(hWnd: DWORD; lpText, lpCaption: PChar; uType: DWORD): Integer; stdcall; external 'user32.dll';
function LoadLibraryA(lpLibFileName: PAnsiChar): HMODULE; stdcall; external 'kernel32.dll';
function FreeLibrary(hLibModule: HMODULE): Boolean; stdcall; external 'kernel32.dll';
function GetProcAddress(hModule: HMODULE; lpProcName: PAnsiChar): Pointer; stdcall; external 'kernel32.dll';

procedure LoadOMEGA;
Begin
LibOmega := LoadLibraryA( PChar( FileName ) );

if LibOmega <> 0 Then
  begin
    @OE_Test                    := GetProcAddress( LibOmega, 'OE_Test' );
    @OE_Init                    := GetProcAddress( LibOmega, 'OE_Init' );
    @OE_Init2                   := GetProcAddress( LibOmega, 'OE_Init2' );
    @OE_Quit                    := GetProcAddress( LibOmega, 'OE_Quit' );
    @OE_RegProcedure            := GetProcAddress( LibOmega, 'OE_RegProcedure' );
    @OE_UnRegProcedure          := GetProcAddress( LibOmega, 'OE_UnRegProcedure' );
    @Timer_Create               := GetProcAddress( LibOmega, 'Timer_Create' );
    @Timer_Free                 := GetProcAddress( LibOmega, 'Timer_Free' );
    @Timer_FreeAll              := GetProcAddress( LibOmega, 'Timer_FreeAll' );
    @OE_Enable                  := GetProcAddress( LibOmega, 'OE_Enable' );
    @OE_Disable                 := GetProcAddress( LibOmega, 'OE_Disable' );
    @OE_SetWndOnTop             := GetProcAddress( LibOmega, 'OE_SetWndOnTop' );
    @OE_SetWndPosition          := GetProcAddress( LibOmega, 'OE_SetWndPosition' );
    @OE_SetWndName              := GetProcAddress( LibOmega, 'OE_SetWndName' );
    @OE_ResizeWindow            := GetProcAddress( LibOmega, 'OE_ResizeWindow' );
    @OE_ShowCursor              := GetProcAddress( LibOmega, 'OE_ShowCursor' );
    @OE_SetScreenOptions        := GetProcAddress( LibOmega, 'OE_SetScreenOptions' );
    @OE_ChangeScreenOptions     := GetProcAddress( LibOmega, 'OE_ChangeScreenOptions' );
    @OE_SetResolutionDependence := GetProcAddress( LibOmega, 'OE_SetResolutionDependence' );
    @OE_SetVSync                := GetProcAddress( LibOmega, 'OE_SetVSync' );
    @OE_GetOptions              := GetProcAddress( LibOmega, 'OE_GetOptions' );
    @OE_SetAdvancedOptions      := GetProcAddress( LibOmega, 'OE_SetAdvancedOptions' );
    @OE_GetFPS                  := GetProcAddress( LibOmega, 'OE_GetFPS' );
    @INI_LoadFromFile           := GetProcAddress( LibOmega, 'INI_LoadFromFile' );
    @INI_LoadFromMemory         := GetProcAddress( LibOmega, 'INI_LoadFromMemory' );
    @INI_SaveToFile             := GetProcAddress( LibOmega, 'INI_SaveToFile' );
    @INI_Add                    := GetProcAddress( LibOmega, 'INI_Add' );
    @INI_ReadKeyStr             := GetProcAddress( LibOmega, 'INI_ReadKeyStr' );
    @INI_ReadKeyInt             := GetProcAddress( LibOmega, 'INI_ReadKeyInt' );
    @INI_WriteKeyStr            := GetProcAddress( LibOmega, 'INI_WriteKeyStr' );
    @INI_WriteKeyInt            := GetProcAddress( LibOmega, 'INI_WriteKeyInt' );
    @LOG_SetOptions             := GetProcAddress( LibOmega, 'LOG_SetOptions' );
    @LOG_Init                   := GetProcAddress( LibOmega, 'LOG_Init' );
    @LOG_AddMessage             := GetProcAddress( LibOmega, 'LOG_AddMessage' );
    @LOG_AddLine                := GetProcAddress( LibOmega, 'LOG_AddLine' );
    @Key_LoadLayout             := GetProcAddress( LibOmega, 'Key_LoadLayout' );
    @KeyEx_Down                 := GetProcAddress( LibOmega, 'KeyEx_Down' );
    @Key_Down                   := GetProcAddress( LibOmega, 'Key_Down' );
    @Key_Press                  := GetProcAddress( LibOmega, 'Key_Press' );
    @Key_LastDown               := GetProcAddress( LibOmega, 'Key_LastDown' );
    @Key_LastPress              := GetProcAddress( LibOmega, 'Key_LastPress' );
    @Key_BeginReadText          := GetProcAddress( LibOmega, 'Key_BeginReadText' );
    @Key_EndReadText            := GetProcAddress( LibOmega, 'Key_EndReadText' );
    @Key_MaxReadText            := GetProcAddress( LibOmega, 'Key_MaxReadText' );
    @MouseEx_X                  := GetProcAddress( LibOmega, 'MouseEx_X' );
    @MouseEx_Y                  := GetProcAddress( LibOmega, 'MouseEx_Y' );
    @MouseEx_Down               := GetProcAddress( LibOmega, 'MouseEx_Down' );
    @Mouse_X                    := GetProcAddress( LibOmega, 'Mouse_X' );
    @Mouse_Y                    := GetProcAddress( LibOmega, 'Mouse_Y' );
    @Mouse_Move                 := GetProcAddress( LibOmega, 'Mouse_Move' );
    @Mouse_Lock                 := GetProcAddress( LibOmega, 'Mouse_Lock' );
    @Mouse_DeltaX               := GetProcAddress( LibOmega, 'Mouse_DeltaX' );
    @Mouse_DeltaY               := GetProcAddress( LibOmega, 'Mouse_DeltaY' );
    @Mouse_Down                 := GetProcAddress( LibOmega, 'Mouse_Down' );
    @Mouse_Press                := GetProcAddress( LibOmega, 'Mouse_Press' );
    @Mouse_Click                := GetProcAddress( LibOmega, 'Mouse_Click' );
    @Mouse_DblClick             := GetProcAddress( LibOmega, 'Mouse_DblClick' );
    @Mouse_WheelUp              := GetProcAddress( LibOmega, 'Mouse_WheelUp' );
    @Mouse_WheelDown            := GetProcAddress( LibOmega, 'Mouse_WheelDown' );
    @Joy_Down                   := GetProcAddress( LibOmega, 'Joy_Down' );
    @Joy_Press                  := GetProcAddress( LibOmega, 'Joy_Press' );
    @Joy_AxePos                 := GetProcAddress( LibOmega, 'Joy_AxePos' );
    @Tex_Filter                 := GetProcAddress( LibOmega, 'Tex_Filter' );
    @Tex_SetAnisotropyLevel     := GetProcAddress( LibOmega, 'Tex_SetAnisotropyLevel' );
    @Tex_CreateZero             := GetProcAddress( LibOmega, 'Tex_CreateZero' );
    @Tex_LoadFromFile           := GetProcAddress( LibOmega, 'Tex_LoadFromFile' );
    @Tex_LoadFromMemory         := GetProcAddress( LibOmega, 'Tex_LoadFromMemory' );
    @Tex_Free                   := GetProcAddress( LibOmega, 'Tex_Free' );
    @Tex_FreeAll                := GetProcAddress( LibOmega, 'Tex_FreeAll' );
    @Tex_LoadMaskFromFile       := GetProcAddress( LibOmega, 'Tex_LoadMaskFromFile' );
    @Tex_LoadMaskFromMemory     := GetProcAddress( LibOmega, 'Tex_LoadMaskFromMemory' );
    @Tex_FreeMask               := GetProcAddress( LibOmega, 'Tex_FreeMask' );
    @Tex_SetFramesSize          := GetProcAddress( LibOmega, 'Tex_SetFramesSize' );
    @Tex_BeginRenderIn          := GetProcAddress( LibOmega, 'Tex_BeginRenderIn' );
    @Tex_EndRenderIn            := GetProcAddress( LibOmega, 'Tex_EndRenderIn' );
    @Cam2D_Create               := GetProcAddress( LibOmega, 'Cam2D_Create' );
    @Cam2D_Free                 := GetProcAddress( LibOmega, 'Cam2D_Free' );
    @Cam2D_FreeAll              := GetProcAddress( LibOmega, 'Cam2D_FreeAll' );
    @Cam2D_Set                  := GetProcAddress( LibOmega, 'Cam2D_Set' );
    @FX_SetColorMix             := GetProcAddress( LibOmega, 'FX_SetColorMix' );
    @FX_SetBlendMode            := GetProcAddress( LibOmega, 'FX_SetBlendMode' );
    @FX_SetScale                := GetProcAddress( LibOmega, 'FX_SetScale' );
    @FX_SetVertexes             := GetProcAddress( LibOmega, 'FX_SetVertexes' );
    @FX_SetVCA                  := GetProcAddress( LibOmega, 'FX_SetVCA' );
    @FX_Blur_SetTex             := GetProcAddress( LibOmega, 'FX_Blur_SetTex' );
    @FX_Blur_SetParams          := GetProcAddress( LibOmega, 'FX_Blur_SetParams' );
    @FX_Blur_Calc               := GetProcAddress( LibOmega, 'FX_Blur_Calc' );
    @FX_Blur_Draw               := GetProcAddress( LibOmega, 'FX_Blur_Draw' );
    @FX_RadBlur_SetTex          := GetProcAddress( LibOmega, 'FX_RadBlur_SetTex' );
    @FX_RadBlur_SetParams       := GetProcAddress( LibOmega, 'FX_RadBlur_SetParams' );
    @FX_RadBlur_Calc            := GetProcAddress( LibOmega, 'FX_RadBlur_Calc' );
    @FX_RadBlur_Draw            := GetProcAddress( LibOmega, 'FX_RadBlur_Draw' );
    @Text_LoadFontFromFile      := GetProcAddress( LibOmega, 'Text_LoadFontFromFile' );
    @Text_LoadFontFromMemory    := GetProcAddress( LibOmega, 'Text_LoadFontFromMemory' );
    @Text_FreeFont              := GetProcAddress( LibOmega, 'Text_FreeFont' );
    @Text_FreeFontAll           := GetProcAddress( LibOmega, 'Text_FreeFontAll' );
    @Text_Draw                  := GetProcAddress( LibOmega, 'Text_Draw' );
    @Text_GetWidth              := GetProcAddress( LibOmega, 'Text_GetWidth' );
    @Text_InitDebugFont         := GetProcAddress( LibOmega, 'Text_InitDebugFont' );
    @Text_FreeDebugFont         := GetProcAddress( LibOmega, 'Text_FreeDebugFont' );
    @Text_DrawDebugText         := GetProcAddress( LibOmega, 'Text_DrawDebugText' );
    @Console_Active             := GetProcAddress( LibOmega, 'Console_Active' );
    @Console_SetOptions         := GetProcAddress( LibOmega, 'Console_SetOptions' );
    @Console_ToLog              := GetProcAddress( LibOmega, 'Console_ToLog' );
    @Console_Draw               := GetProcAddress( LibOmega, 'Console_Draw' );
    @Console_RegCommand         := GetProcAddress( LibOmega, 'Console_RegCommand' );
    @Console_RegVariable        := GetProcAddress( LibOmega, 'Console_RegVariable' );
    @Console_RegProcedure       := GetProcAddress( LibOmega, 'Console_RegProcedure' );
    @Console_AddString          := GetProcAddress( LibOmega, 'Console_AddString' );
    @Pr2D_PixelSize             := GetProcAddress( LibOmega, 'Pr2D_PixelSize' );
    @Pr2D_LineWidth             := GetProcAddress( LibOmega, 'Pr2D_LineWidth' );
    @Pr2D_Pixel                 := GetProcAddress( LibOmega, 'Pr2D_Pixel' );
    @Pr2D_Line                  := GetProcAddress( LibOmega, 'Pr2D_Line' );
    @Pr2D_TLine                 := GetProcAddress( LibOmega, 'Pr2D_TLine' );
    @Pr2D_Rect                  := GetProcAddress( LibOmega, 'Pr2D_Rect' );
    @Pr2D_TRect                 := GetProcAddress( LibOmega, 'Pr2D_TRect' );
    @Pr2D_Triangle              := GetProcAddress( LibOmega, 'Pr2D_Triangle' );
    @Pr2D_TTriangle             := GetProcAddress( LibOmega, 'Pr2D_TTriangle' );
    @Pr2D_Circle                := GetProcAddress( LibOmega, 'Pr2D_Circle' );
    @Pr2D_TCircle               := GetProcAddress( LibOmega, 'Pr2D_TCircle' );
    @Pr2D_Ellipse               := GetProcAddress( LibOmega, 'Pr2D_Ellipse' );
    @Pr2D_Polygon               := GetProcAddress( LibOmega, 'Pr2D_Polygon' );
    @Pr2D_PolygonCA             := GetProcAddress( LibOmega, 'Pr2D_PolygonCA' );
    @SSprite_Draw               := GetProcAddress( LibOmega, 'SSprite_Draw' );
    @ASprite_Draw               := GetProcAddress( LibOmega, 'ASprite_Draw' );
    @CSprite_Draw               := GetProcAddress( LibOmega, 'CSprite_Draw' );
    @STile_Draw                 := GetProcAddress( LibOmega, 'STile_Draw' );
    @ATile_Draw                 := GetProcAddress( LibOmega, 'ATile_Draw' );
    @Scissor_Begin              := GetProcAddress( LibOmega, 'Scissor_Begin' );
    @Scissor_End                := GetProcAddress( LibOmega, 'Scissor_End' );
    @Snd_Init                   := GetProcAddress( LibOmega, 'Snd_Init' );
    @Snd_Active                 := GetProcAddress( LibOmega, 'Snd_Active' );
    @Snd_LoadFromFile           := GetProcAddress( LibOmega, 'Snd_LoadFromFile' );
    @Snd_LoadFromMemory         := GetProcAddress( LibOmega, 'Snd_LoadFromMemory' );
    @Snd_Free                   := GetProcAddress( LibOmega, 'Snd_Free' );
    @Snd_FreeAll                := GetProcAddress( LibOmega, 'Snd_FreeAll' );
    @Snd_SetBuffersCount        := GetProcAddress( LibOmega, 'Snd_SetBuffersCount' );
    @Snd_Play                   := GetProcAddress( LibOmega, 'Snd_Play' );
    @Snd_PlayID                 := GetProcAddress( LibOmega, 'Snd_PlayID' );
    @Snd_Stop                   := GetProcAddress( LibOmega, 'Snd_Stop' );
    @Snd_StopID                 := GetProcAddress( LibOmega, 'Snd_StopID' );
    @Snd_StopAll                := GetProcAddress( LibOmega, 'Snd_StopAll' );
    @Snd_ChangeParam            := GetProcAddress( LibOmega, 'Snd_ChangeParam' );
    @Media_Play                 := GetProcAddress( LibOmega, 'Media_Play' );
    @Media_Replay               := GetProcAddress( LibOmega, 'Media_Replay' );
    @Media_Pause                := GetProcAddress( LibOmega, 'Media_Pause' );
    @Media_Resume               := GetProcAddress( LibOmega, 'Media_Resume' );
    @Media_Stop                 := GetProcAddress( LibOmega, 'Media_Stop' );
    @Media_SetVolume            := GetProcAddress( LibOmega, 'Media_SetVolume' );
    @Media_GetLength            := GetProcAddress( LibOmega, 'Media_GetLength' );
    @Media_SetPosition          := GetProcAddress( LibOmega, 'Media_SetPosition' );
    @Media_GetPosition          := GetProcAddress( LibOmega, 'Media_GetPosition' );
    @Media_SetWindowRect        := GetProcAddress( LibOmega, 'Media_SetWindowRect' );
    @Col_PointInAABB            := GetProcAddress( LibOmega, 'Col_PointInAABB' );
    @Col_PointInCircle          := GetProcAddress( LibOmega, 'Col_PointInCircle' );
    @Col_PointInPolyLine        := GetProcAddress( LibOmega, 'Col_PointInPolyLine' );
    @Col_Line                   := GetProcAddress( LibOmega, 'Col_Line' );
    @Col_LineVsAABB             := GetProcAddress( LibOmega, 'Col_LineVsAABB' );
    @Col_LineVsCircle           := GetProcAddress( LibOmega, 'Col_LineVsCircle' );
    @Col_LineVsCircleXY         := GetProcAddress( LibOmega, 'Col_LineVsCircleXY' );
    @Col_LineVsPolyLine         := GetProcAddress( LibOmega, 'Col_LineVsPolyLine' );
    @Col_PolyLine               := GetProcAddress( LibOmega, 'Col_PolyLine' );
    @Col_PolyLineVsAABB         := GetProcAddress( LibOmega, 'Col_PolyLineVsAABB' );
    @Col_PolyLineVsCircle       := GetProcAddress( LibOmega, 'Col_PolyLineVsCircle' );
    @Col_PolyLineVsCircleXY     := GetProcAddress( LibOmega, 'Col_PolyLineVsCircleXY' );
    @Col_AABB                   := GetProcAddress( LibOmega, 'Col_AABB' );
    @Col_AABBInAABB             := GetProcAddress( LibOmega, 'Col_AABBInAABB' );
    @Col_AABBInCircle           := GetProcAddress( LibOmega, 'Col_AABBInCircle' );
    @Col_AABBVsCircle           := GetProcAddress( LibOmega, 'Col_AABBVsCircle' );
    @Col_Circle                 := GetProcAddress( LibOmega, 'Col_Circle' );
    @Col_CircleInCircle         := GetProcAddress( LibOmega, 'Col_CircleInCircle' );
    @Col_CircleInAABB           := GetProcAddress( LibOmega, 'Col_CircleInAABB' );
    @ColEx_LastX                := GetProcAddress( LibOmega, 'ColEx_LastX' );
    @ColEx_LastY                := GetProcAddress( LibOmega, 'ColEx_LastY' );
    @ColEx_LastLineA            := GetProcAddress( LibOmega, 'ColEx_LastLineA' );
    @ColEx_LastLineB            := GetProcAddress( LibOmega, 'ColEx_LastLineB' );
    @ColEx_PolyRotate           := GetProcAddress( LibOmega, 'ColEx_PolyRotate' );
    @ColEx_PolyScale            := GetProcAddress( LibOmega, 'ColEx_PolyScale' );
    @ColEx_PolyMove             := GetProcAddress( LibOmega, 'ColEx_PolyMove' );
    @ColEx_PolyCenter           := GetProcAddress( LibOmega, 'ColEx_PolyCenter' );
    @ColEx_PolyRect             := GetProcAddress( LibOmega, 'ColEx_PolyRect' );
    @ColEx_CalcLineCross        := GetProcAddress( LibOmega, 'ColEx_CalcLineCross' );
    @M_Cos                      := GetProcAddress( LibOmega, 'M_Cos' );
    @M_Sin                      := GetProcAddress( LibOmega, 'M_Sin' );
    @M_CosF                     := GetProcAddress( LibOmega, 'M_CosF' );
    @M_SinF                     := GetProcAddress( LibOmega, 'M_SinF' );
    @M_Round                    := GetProcAddress( LibOmega, 'M_Round' );
    @M_Trunc                    := GetProcAddress( LibOmega, 'M_Trunc' );
    @M_Distance                 := GetProcAddress( LibOmega, 'M_Distance' );
    @M_FindAngle                := GetProcAddress( LibOmega, 'M_FindAngle' );
    @Mem_Get                    := GetProcAddress( LibOmega, 'Mem_Get' );
    @Mem_Realloc                := GetProcAddress( LibOmega, 'Mem_Realloc' );
    @Mem_Free                   := GetProcAddress( LibOmega, 'Mem_Free' );
    @U_GetCPUName               := GetProcAddress( LibOmega, 'U_GetCPUName' );
    @U_GetTotalRAM              := GetProcAddress( LibOmega, 'U_GetTotalRAM' );
    @U_Is3DAccelerator          := GetProcAddress( LibOmega, 'U_Is3DAccelerator' );
    @U_GetMaxTexSize            := GetProcAddress( LibOmega, 'U_GetMaxTexSize' );
    @U_GetMaxAnisotropy         := GetProcAddress( LibOmega, 'U_GetMaxAnisotropy' );
    @U_SnapShot                 := GetProcAddress( LibOmega, 'U_SnapShot' );
    @U_IntToStr                 := GetProcAddress( LibOmega, 'U_IntToStr' );
    @U_StrToInt                 := GetProcAddress( LibOmega, 'U_StrToInt' );
    @U_FloatToStr               := GetProcAddress( LibOmega, 'U_FloatToStr' );
    @U_GetTime                  := GetProcAddress( LibOmega, 'U_GetTime' );
    @P_GetParams                := GetProcAddress( LibOmega, 'P_GetParams' );
    @Tex_PostProcess            := GetProcAddress( LibOmega, 'Tex_PostProcess' );    
  end else
    MessageBoxA( 0, 'Error while loading OMEGA Engine', 'Error', $00000010 );
End;

procedure FreeOMEGA;
Begin
FreeLibrary( LibOmega );
End;

function VOLUME;
Begin
Result := -50 * ( 100 - Value );
End;

initialization
  Set8087CW( $133F );
end.
